(function () {
  "use strict";

  const DEFAULT_BACKEND_URL = "https://shop.aantz.com";

  const urlInput = document.getElementById("backendUrl");
  const saveBtn = document.getElementById("saveBtn");
  const testBtn = document.getElementById("testBtn");
  const statusEl = document.getElementById("status");

  // Load saved setting
  chrome.storage.sync.get({ backendUrl: DEFAULT_BACKEND_URL }, (items) => {
    urlInput.value = items.backendUrl;
  });

  saveBtn.addEventListener("click", () => {
    const url = urlInput.value.trim().replace(/\/+$/, "");
    if (!url) {
      showStatus("Please enter a URL", "error");
      return;
    }
    chrome.storage.sync.set({ backendUrl: url }, () => {
      showStatus("Saved!", "success");
    });
  });

  testBtn.addEventListener("click", async () => {
    const url = urlInput.value.trim().replace(/\/+$/, "");
    if (!url) {
      showStatus("Please enter a URL", "error");
      return;
    }
    showStatus("Testing...", "success");
    try {
      const resp = await fetch(`${url}/healthz`, { method: "GET" });
      if (!resp.ok) throw new Error(`HTTP ${resp.status}`);
      const data = await resp.json();
      if (data.status === "ok") {
        showStatus("Connected successfully!", "success");
      } else {
        showStatus("Unexpected response: " + JSON.stringify(data), "error");
      }
    } catch (e) {
      showStatus("Connection failed: " + e.message, "error");
    }
  });

  function showStatus(msg, type) {
    statusEl.textContent = msg;
    statusEl.className = "status " + type;
  }
})();
